"use strict";

//=> Class Definition
var Bundle = function () {

    // Holds plugin instance
    var sticky;
    var mediaPlayer;
    var wave;

    // Class names
    var show = 'show';
    var active = 'active';

    // Keys to use for store data in local storage
    var dark = 'dark';
    var radio = 'radio';

    // Holds playlist data
    var playlist = [];

    var $body = $('body');

    var audioPlayer = document.getElementById('audio_player');
    var visualizer = document.getElementById('visualizer');
    var visualizerWrap = document.getElementById('visualizer_wrap');

    /**
     * Initialize Bootstrap tooltip
     *-------------------------------------------------------------------------------*/
    var initTooltip = () => {
        $('[data-bs-toggle="tooltip"]').tooltip();
    }

    /**
     * Initialize swiper slider
     * Plugin: Swiper [https://swiperjs.com/]
     *-------------------------------------------------------------------------------*/
    var initSwiper = function () {
        $('.swiper').each(function () {
            var slides = parseInt(this.getAttribute('data-swiper-slides'));
            var carousel = this.parentElement;
            var loop = this.getAttribute('data-swiper-loop');
            var air = this.getAttribute('data-swiper-air');
            var autoplay = this.getAttribute('data-swiper-autoplay');
            var next = carousel.querySelector('.swiper-button-next');
            var prev = carousel.querySelector('.swiper-button-prev');
            var pagination = carousel.querySelector('.swiper-pagination');
            var paginationType = this.getAttribute('data-swiper-pagination') ? this.getAttribute('data-swiper-pagination') : 'bullets';
            var scrollbar = carousel.querySelector('.swiper-scrollbar');
            
            // Spacing between slides
            var desktopSpace = 24;
            var mobileSpace = 16;
            
            // Set responsive slide
            var desktop = slides;
            var tablet = 3;
            var mobile = 2;
            var smallMobile = 1;
            
            if (slides <= 2) {
                tablet = mobile = smallMobile = 1;
                
            } else {
                if (slides > 1 && slides < 4) {
                    tablet = 3;
                    mobile = 2;
                    smallMobile = 1;
                } else if (slides >= 5) {
                    tablet = 4;
                    mobile = 3;
                    smallMobile = 2;
                }
            }
            
            if (air) {
                desktopSpace = desktopSpace - 8;
                mobileSpace = mobileSpace - 8;
            }
            
            // Swiper options
            var options = {
                speed: 500,
                slidesPerView: smallMobile,
                slidesPerGroup: smallMobile,
                spaceBetween: mobileSpace,
                
                a11y: true,
                
                breakpoints: {
                    375: {
                        slidesPerView: mobile,
                        slidesPerGroup: mobile
                    },
                    640: {
                        slidesPerView: tablet,
                        slidesPerGroup: tablet
                    },
                    992: {
                        slidesPerView: desktop,
                        slidesPerGroup: desktop,
                        spaceBetween: desktopSpace
                    }
                }
            }
            
            if (loop) {
                options.loop = loop;
            }
            
            if (autoplay) {
                options.autoplay = {
                    delay: 5000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true
                };
            }
            
            // Add next & prev controls in swiper option if element is exist.
            if (next && prev) {
                options.navigation = {
                    nextEl: next,
                    prevEl: prev,
                }
            }
            
            // Add pagination control in swiper option if element is exist.
            if (pagination) {
                options.pagination = {
                    el: pagination,
                    type: paginationType,
                    clickable: true,
                    dynamicBullets: true
                }
            }
            
            // Add scrollbar control in swiper option if element is exist.
            if (scrollbar) {
                options.scrollbar = {
                    el: scrollbar,
                    draggable: true
                }
            }
            
            // Bind swiper slider with element.
            new Swiper(this, options);
        });
    }

    /**
     * Initialize sticky content
     * Plugin: Sticky Sidebar [https://abouolia.github.io/sticky-sidebar/]
     *-------------------------------------------------------------------------------*/
    var stickyContent = function () {
        $('#sticky_main').imagesLoaded(function () {
            var offsetTop = $('#header').height() + 16;
            var content, inner;
            
            if (sticky) {
                sticky.destroy();
            }
            
            if ($(window).width() > 991.98) {
                if ($('#sticky_main').height() < $('#sticky_sidebar').height()) {
                    content = '#sticky_main';
                    inner = '#sticky_main_content';
                } else if ($('#sticky_main').height() > $('#sticky_sidebar').height()) {
                    content = '#sticky_sidebar';
                    inner = '#sticky_sidebar_content';
                }
                
                if (content) {
                    sticky = new StickySidebar(content, {
                        containerSelector: '#sticky_content',
                        innerWrapperSelector: inner,
                        topSpacing: offsetTop,
                        bottomSpacing: 16,
                        resizeSensor: true
                    });
                    
                    var placement = document.getElementById('visualizer_placement');
                    if (placement) {
                        window.addEventListener('scroll', function () {
                            var { top } = placement.getBoundingClientRect();
                            visualizerWrap.style.top = top + 'px';
                            console.log('top :>> ', top);
                        });
                    }
                }
            }
        });
    }

    /**
     * Prevent page loading with AJAX 
     *-------------------------------------------------------------------------------*/
    var routing = function () {
        var link = 'a:not([href^="#"])a:not([href^="mail"])a:not([href^="tel"]):not([href^="javascript"]):not(.external):not([target])';
        $(document).on('click', link, function (e) {
            e.preventDefault();
            e.stopPropagation();
    
            var url = $(this).attr('href') !== 'undefined' ? $(this).attr('href') : null;
            if (url) {
                var history = window.history;
                history.pushState("", "", url);
                changeRouteHTML(url);
            }
        });
    }
    
    /**
     * Search data
     *-------------------------------------------------------------------------------*/
    var search = function () {
       
       $(document).on('click', '#pb_search_icon', function() {
            if ($('#pb-search-input').val()) {
                var text = encodeURIComponent($('#pb-search-input').val());
                var url = base_url + 'search?q=' + text; 
                changeRouteHTML(url);
            }
        });
        $(document).on('keyup', '#pb-search-input', function(event) {
            if (event.keyCode === 13) {
                if ($('#pb-search-input').val()) {
                    var text = encodeURIComponent($('#pb-search-input').val());
                    var url = base_url + 'search?q=' + text; 
                    changeRouteHTML(url);
                }
            }
        });
    }
    
    var browserAction = function () {
        $(window).on('popstate', function () {
            var href = window.location.href;
            var url = href.split('/').pop();
            changeRouteHTML(url);
        });
    }

    /**
     * scroll to Top
     *-------------------------------------------------------------------------------*/
    var scrollTop = function () {

        var button = document.getElementById('btn-back-to-top');
        
        window.onscroll = function () {
            if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
                button.style.top = "90%";
            } else {
                button.style.top = "100%";
            }
        };
        button.addEventListener("click", backToTop);
        function backToTop() {
          document.body.scrollTop = 0;
          document.documentElement.scrollTop = 0;
        }
    }
    
    /**
     * loadMore
     *-------------------------------------------------------------------------------*/
    var loadMore = function () {
        
        const container = document.getElementById('load-more-container');
        const loadMoreBtn = document.getElementById('load-more-btn');
        if(container && loadMoreBtn){
            
            let visibleCards = 16;
            
            loadMoreBtn.addEventListener('click', () => {
                const cards = container.querySelectorAll('.card-item');
                for (let i = visibleCards; i < visibleCards + 16 && i < cards.length; i++) {
                    cards[i].style.display = 'block';
                }
                
                visibleCards += 16;
                if (visibleCards >= cards.length) {
                    loadMoreBtn.style.display = 'none';
                }
                
                stickyContent();
            });
            
            const cards = container.querySelectorAll('.card-item');
            for (let i = 16; i < cards.length; i++) {
                cards[i].style.display = 'none';
            }
            
            if (cards.length > 16) {
                loadMoreBtn.style.display = 'block';
            } else {
                loadMoreBtn.style.display = 'none';
            }
        }
    }
    
    /**
     * cookie
     *-------------------------------------------------------------------------------*/
    var cookie = function () {

        if (getLocalItem('cookie')) {
           $(".cookie").addClass(active);
        }
        
        $('.accept').on('click', function () {
            $(".cookie").addClass(active);
            setLocalItem('cookie', true);
             $.notify('Cookie Accept successfully.', { position:"top right",className: 'success'} );
        });
    }

    /**
     * Change theme skins
     *-------------------------------------------------------------------------------*/
    var changeThemeSkin = function () {

        // Theme dark mode
        var darkMode = function () {
            $('#dark_mode').addClass(active);
            $body.attr('data-theme', dark);
            setLocalItem(dark, true);
        };
        
        if (getLocalItem(dark)) {
            darkMode();
        }
        
        // Dark mode on click
        $('#dark_mode').on('click', function () {
            if ($(this).hasClass(active)) {
                $(this).removeClass(active);
                $body.removeAttr('data-theme');
                removeLocalItem(dark);
            } else {
                darkMode();
            }
        });
    }

    /**
     * Embedded player event for play/pause
     *-------------------------------------------------------------------------------*/
    var embeddedAudioPlayer = function () {
        var button = document.getElementById('embedded_play');
        var player = document.getElementById('embedded_player');
        var text = document.getElementById('embedded_play_text');
        
        if (button) {
            button.addEventListener('click', function () {
                if (this.classList.contains(active)) {
                    player.pause();
                    text.innerHTML = 'Play Now';
                    this.classList.remove(active);
                } else {
                    player.play();
                    text.innerHTML = 'Pause';
                    this.classList.add(active);
                }
            });
        }
    }

    /**
     * Share radio link and embedded code
     *-------------------------------------------------------------------------------*/
    var shareModal = function () {
       
        var modal = document.getElementById('share_radio');
        
        if (modal) {
            modal.addEventListener('show.bs.modal', function (event) {
                var url = modal.querySelector('#share_radio_url');
                var frame = modal.querySelector('#share_radio_frame');
                var id = event.relatedTarget.getAttribute('data-share-id');
                var share_href = event.relatedTarget.getAttribute('data-share-href');
                
                var linkFrame = base_url + `embedded/${id}`
                
                url.innerText = share_href;
                frame.innerText = `<iframe width="100%" height="210" src="${linkFrame}" frameborder="0"></iframe>`;
            });
        }
    }

    /**
     * Copy text on click
     *-------------------------------------------------------------------------------*/
    var clipboard = function () {
        $('[data-copy]').on('click', function () {
            var html = document.createElement('div');
            html.className = 'alert-wrap';
            
            var element = document.getElementById($(this).attr('data-copy'));
            var successful = copyToClipboard(element);
            
            if (successful) {
                html.innerHTML = `<div class="alert alert-success d-flex align-items-center" role="alert">
                    <svg class="bi flex-shrink-0 me-2" width="16" height="16" role="img" aria-label="Success:">
                        <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z"/>
                    </svg>
                    <div class="me-auto pe-2">Copied!</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>`;
            } else {
                html.innerHTML = `<div class="alert alert-danger d-flex align-items-center" role="alert">
                    <svg class="bi flex-shrink-0 me-2" width="16" height="16" role="img" aria-label="Danger:">
                        <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
                    </svg>
                    <div class="me-auto pe-2">Whoops, not copied!</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>`;
            }
            document.body.appendChild(html);
            
            var timer = setTimeout(() => {
                document.body.removeChild(html);
                clearTimeout(timer);
            }, 2000);
        });
    }

    /**
     * Copy text in clipboard
     *-------------------------------------------------------------------------------*/
    var copyToClipboard = function (el) {
        var text = el.innerText;
        
        if (window.clipboardData && window.clipboardData.setData) {
            return window.clipboardData.setData("Text", text);
            
        } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
            var textarea = document.createElement("textarea");
            textarea.value = text;
            textarea.style.position = "fixed";  // Prevent scrolling to bottom of page in Microsoft Edge.
            el.appendChild(textarea);
            textarea.select();
            try {
                return document.execCommand('copy');
            } catch (ex) {
                console.warn("Copy to clipboard failed.", ex);
                return prompt("Copy to clipboard: Ctrl+C, Enter", text);
            } finally {
                el.removeChild(textarea);
            }
        }
    }

    /**
     * Click event to set radio in player
     *-------------------------------------------------------------------------------*/
    var addRadio = function () {
        $body.on('click', '[data-radio-id]', function () {
            if (!playlist) {
                playlist = [];
            }
            
            var $this = $(this);
            var id = parseInt($this.attr('data-radio-id'));
            var currentRadio = playlist.find(item => item.id === id);
            
            if ($this.hasClass(active)) {
                $('[data-radio-id=' + id + ']').removeClass(active);
                $('[data-radio-id=' + id + '] .play-btn-text').text('Play Now');
                mediaPlayer.pause();
                
            } else {
                for (var i = 0; i < playlist.length; i++) {
                    var item = playlist[i];
                    item.isPlaying = false;
                }
                
                if (currentRadio) {
                    currentRadio.isPlaying = true;
                } else {
                    if (playlist.length >= 10) {
                        playlist.shift();
                    }
                    
                    currentRadio = getRadio($this);
                    currentRadio.isPlaying = true;
                    playlist.push(currentRadio);
                    $('#playlist').append(playlistItemView(currentRadio));
                }
                
                // Set data in the player
                $('#player').addClass('visible');
                changePlayerData(currentRadio);
                
                if (playlist.length > 1) {
                    $('.mejs__button button').attr('disabled', false);
                }
                
                // Show player for flew seconds
                if (!$('#player').hasClass(show)) {
                    $('#player').addClass(show);
                    setTimeout(function () {
                        $('#player').removeClass(show);
                        $('#player_info').removeClass(show);
                    }, 2000);
                }
            }
            
            setTimeout(function () {
                setVisualizerPlacement(true);
            }, 200);
            
            setLocalItem(radio, playlist);
        });
    }

    /**
     * Initialize player
     *-------------------------------------------------------------------------------*/
    var initPlayer = function () {
        playlist = getLocalItem(radio) || [];
        
        // Add playlist
        if (playlist.length) {
            $('#player').addClass('visible');
            
            for (let i = 0; i < playlist.length; i++) {
                var item = playlist[i];
                item.isPlaying = false;
                $('#playlist').append(playlistItemView(item));
            }
            
            playlist[0].isPlaying = true;
            
            setLocalItem(radio, playlist);
        }
        
        // Initialize media player
        mediaPlayer = new MediaElementPlayer(audioPlayer, {
            features: ['prevtrack', 'playpause', 'nexttrack', 'current', 'volume'],
            success: function () { },
            error: function () {
                var html = document.createElement('div');
                html.className = 'alert-wrap';
                html.innerHTML = `<div class="alert alert-danger d-flex align-items-center" role="alert">
                    <svg class="bi flex-shrink-0 me-2" width="16" height="16" role="img" aria-label="Danger:">
                        <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
                    </svg>
                    <div class="me-auto pe-2">Network error</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>`;
            }
        });
        
        if (mediaPlayer.media) {
            setupPlayer();
        }
    }

    /**
     * Player click events
     *-------------------------------------------------------------------------------*/
    var playerEvents = function () {
        // Toggle player
        $('#player_toggler').on('click', function () {
            $('#player').toggleClass(show);
            $('#player_info').removeClass(show);
        });
        
        // Remove radio from player
        $body.on('click', '[data-remove-radio-id]', function () {
            var $this = $(this);
            var id = parseInt($this.attr('data-remove-radio-id'));
            var index = playlist.findIndex(item => item.id === id);
            var currentRadio = playlist.find(item => item.id === id);
            
            $this.parent().remove();
            playlist.splice(index, 1);
            
            if (index === playlist.length) {
                index = 0;
            }
            
            if (currentRadio.isPlaying) {
                var obj = playlist[index];
                mediaPlayer.setSrc(obj.url);
                
                // Change radio data
                $('.radio-cover').attr('src', obj.cover);
                $('#radio_title').text(obj.title);
                $('#radio_category').text(obj.category);
                
                $('[data-radio-id=' + currentRadio.id + ']').removeClass(active);
                $('[data-radio-id=' + currentRadio.id + '] .play-btn-text').text('Play Now');
            }
            $.notify('Remove radio from player', { position:"top right",className: 'success'} );
            setLocalItem(radio, playlist);
        });
        
        // Close playlist view
        $('#close_playlist').on('click', function () {
            $('#player_info').removeClass(show);
        });
        
        // Clear playlist data
        $('#clear_playlist').on('click', function () {
            $('#player_info').removeClass(show);
            $('#playlist').empty();
            $('.mejs__button:not(.mejs__playpause-button):not(.mejs__volume-button) > button').attr('disabled', true);
            $('[data-radio-id]').removeClass(active);
            
            playlist = [];
            if (isMediaPlaying()) {
                mediaPlayer.pause();
            }
            
            setLocalItem(radio, playlist);
            $.notify(' Clear playlist data', { position:"top right",className: 'success'} );
        });
    }

    /**
     * Reinitialize plugins and event on route change
     *-------------------------------------------------------------------------------*/
    var reInit = function () {
        initSwiper();
        changeThemeSkin();
        shareModal();
        clipboard();
        cookie();
        loadMore();
    }

    /**
     * Replace old route html with new one
     * @param {string} url
     *-------------------------------------------------------------------------------*/
    var changeRouteHTML = function (url) {
        if (url) {
            var $lineLoader = $('#line_loader');
            var history = window.history;
            history.pushState("", "", url);
            
            $lineLoader.show().animate({
                width: 20 + 80 * Math.random() + "%"
            }, 200);
            
            $.ajax({
                url: url,
                type: 'GET',
                dataType: 'html'
            }).done(function (html, status, response) {
                if (status === 'success' && response.status == 200) {
                    html = $('<div>' + html + '</div>');
                    $('head title').html(html.find('title').html());
                    $('#main').html(html.find('#main').html());
                    $('html, body').animate({
                        scrollTop: 0
                    }, 100);
                    
                    visualizerWrap.style.visibility = 'hidden';
                    
                    var audioTag = html.find('#audio_player');
                    audioPlayer = audioTag.get(0);
                    
                    // Initialize click events
                    reInit();
                    changeButtonView();
                    setVisualizerPlacement();
                }
            }).fail(function () {
                var link404 = base_url + `404`
                window.location.href = link404;
            }).always(function () {
                $lineLoader.animate({ width: "100%" }, 200).fadeOut(300, function () {
                    $(this).width("0");
                    stickyContent();
                });
            });
        }
    }

    /**
     * Player setup
     *-------------------------------------------------------------------------------*/
    var setupPlayer = function () {
        var controls = document.querySelector('.mejs__controls');
        var playPause = document.querySelector('.mejs__playpause-button');
        var volume = document.querySelector('.mejs__volume-button');
        var elNext = document.createElement('div');
        var elPrev = document.createElement('div');
        var elPlaylist = document.createElement('div');
        var elCover = document.createElement('div');
        
        // Object to set default radio in the player
        var defaultRadio = playlist[0];
        if (!defaultRadio) {
            defaultRadio = {
                category: "Music",
                cover: "images/cover/3.jpg",
                id: 1,
                isPlaying: true,
                title: "Radio 24x7",
                url: "https://streamingv2.shoutcast.com/capital-fm-940"
            };
        }
        
        elNext.classList.add('mejs__button');
        elPrev.classList.add('mejs__button');
        elPlaylist.classList.add('mejs__button');
        elCover.classList.add('list-group', 'list-group-flush');
        
        elNext.innerHTML = `<button type="button" aria-controls="${mediaPlayer.id}" title="Next" aria-label="Next" tabindex="0" ${playlist.length < 2 ? 'disabled' : ''}>
            <i class="ri-skip-forward-mini-fill fs-5"></i>
        </button>`;
        elPrev.innerHTML = `<button type="button" aria-controls="${mediaPlayer.id}" title="Previous" aria-label="Previous" tabindex="0" ${playlist.length < 2 ? 'disabled' : ''}>
            <i class="ri-skip-back-mini-fill fs-5"></i>
        </button>`;
        elPlaylist.innerHTML = `<button type="button" aria-controls="${mediaPlayer.id}" title="Playlist" aria-label="Playlist" tabindex="0">
            <i class="ri-play-list-fill fs-5"></i>
        </button>`;
        elCover.innerHTML = `<div class="list-group-item ps-3 pe-4 d-flex align-items-center">
            <div class="list-group__cover">
                <img class="radio-cover" alt="">
            </div>
            <div class="list-group__content ps-2">
                <span id="radio_title" class="list-group__title text-truncate">${defaultRadio.title}</span>
                <span id="radio_category" class="list-group__subtitle">${defaultRadio.category}</span>
            </div>
        </div>`;
        
        playPause.childNodes[0].innerHTML = '<i class="ri-play-fill icon-play"></i><i class="ri-pause-fill icon-pause"></i>';
        if (volume) {
            volume.childNodes[0].innerHTML = '<i class="ri-volume-up-fill volume fs-5"></i> <i class="ri-volume-mute-fill mute fs-5"></i>';
        }
        
        controls.insertBefore(elPrev, playPause);
        controls.insertBefore(elNext, playPause.nextElementSibling);
        controls.insertBefore(elCover, elNext.nextElementSibling);
        controls.appendChild(elPlaylist);
        
        $('.radio-cover').attr('src', defaultRadio.cover);
        mediaPlayer.setSrc(defaultRadio.url);
        
        setupVisualizer();
        
        // Change radio data
        var changeRadio = function (index) {
            var newRadio = playlist[index];
            
            for (let i = 0; i < playlist.length; i++) {
                var item = playlist[i];
                item.isPlaying = false;
            }
            
            newRadio.isPlaying = true;
            mediaPlayer.pause();
            changePlayerData(newRadio);
        }
        
        // Button play pause
        playPause.childNodes[0].addEventListener('click', function () {
            setTimeout(() => {
                changeButtonView();
                setVisualizerPlacement();
            }, 10);
        });
        
        // Next radio
        elNext.childNodes[0].addEventListener('click', function () {
            var index = playlist.findIndex(item => item.isPlaying === true);
            if (index === playlist.length - 1) {
                index = -1;
            }
            index++;
            changeRadio(index);
        });
        
        // Previous radio
        elPrev.childNodes[0].addEventListener('click', function () {
            var index = playlist.findIndex(item => item.isPlaying === true);
            if (index === 0) {
                index = playlist.length;
            }
            index--;
            changeRadio(index);
        });
        
        // Toggle playlist
        elPlaylist.childNodes[0].addEventListener('click', function () {
            $('#player_info').toggleClass(show);
        });
    }

    /**
     * Set visualizer placement in details page
     *-------------------------------------------------------------------------------*/
    var setVisualizerPlacement = function (setTop = false) {
        var visual = document.getElementById('visualizer_placement');
        if (visual) {
            var id = parseInt($('body').find('[data-radio-id]').data('radio-id'));
            if (isCurrentVisualizer(id)) {
                var { top, left, height, width } = visual.getBoundingClientRect();
                
                visualizerWrap.style.left = left + 'px';
                visualizerWrap.style.visibility = 'visible';
                visualizerWrap.style.height = height + 'px';
                visualizerWrap.style.width = width + 'px';
                if (setTop) {
                    visualizerWrap.style.top = top + 'px';
                }
            }
        }
    }

    /**
     * Set visualizer with wave.js
     * Plugin: Wave.js [https://github.com/foobar404/Wave.js/]
     *-------------------------------------------------------------------------------*/
    var setupVisualizer = function () {
        var audio = mediaPlayer.media.childNodes[0];
        wave = new Wave(audio, visualizer);
        
        wave.addAnimation(new wave.animations.Lines({
            lineWidth: 12,
            lineColor: { gradient: ["#de0e02", "#fd7e14", "#ffc107", "#20c997", "#0d6efd", "#6610f2", "#6f42c1", "#de0e02"], rotate: 0 },
            count: 48
        }));
    }

    /**
     * Change player data
     * @param {object} currentRadio
     *-------------------------------------------------------------------------------*/
    var changePlayerData = function (currentRadio) {
        mediaPlayer.setSrc(currentRadio.url);
        mediaPlayer.load();
        
        $.ajax({
            url:  base_url+'update_view/'+currentRadio.id,
        });
        
        $('[data-radio-id]').removeClass(active);
        $('[data-radio-id=' + currentRadio.id + ']').addClass(active);
        $('[data-radio-id=' + currentRadio.id + '] .play-btn-text').text('Pause');
        
        var timeout = setTimeout(function () {
            mediaPlayer.play();
            clearTimeout(timeout);
        }, 200);
        
        // Change radio data
        $('.radio-cover').attr('src', currentRadio.cover);
        $('#radio_title').text(currentRadio.title);
        $('#radio_category').text(currentRadio.category);
    }

    /**
     * Playlist item view
     * @param {object} currentRadio
     * @returns {HTML}
     *-------------------------------------------------------------------------------*/
    var playlistItemView = function (currentRadio) {
        return `<li class="list-group-item px-3 d-flex align-items-center">
            <div class="list-group__cover">
                <img src="${currentRadio.cover}" alt="">
            </div>
            <div class="list-group__content px-2">
                <span class="list-group__title text-truncate">${currentRadio.title}</span>
                <span class="list-group__subtitle">${currentRadio.category}</span>
            </div>
            <a href="javascript:void(0);" class="remove-radio" data-remove-radio-id="${currentRadio.id}">&times;</a>
            <a href="javascript:void(0);" data-radio-id="${currentRadio.id}">
                <i class="ri-play-fill icon-play"></i>
                <i class="ri-pause-fill icon-pause"></i>
            </a>
            <span class="list-group__number"></span>
        </li>`;
    }

    /**
     * Change button view on radio change
     *-------------------------------------------------------------------------------*/
    var changeButtonView = function () {
        var obj = playlist.find(item => item.isPlaying === true);
        if (obj) {
            if (isMediaPlaying()) {
                $('[data-radio-id=' + obj.id + ']').addClass(active);
                $('[data-radio-id=' + obj.id + '] .play-btn-text').text('Pause');
            } else {
                $('[data-radio-id=' + obj.id + ']').removeClass(active);
                $('[data-radio-id=' + obj.id + '] .play-btn-text').text('Play Now');
            }
        }
    }

    /**
     * Media player status
     * @returns {boolean}
     *-------------------------------------------------------------------------------*/
    var isMediaPlaying = function () {
        return !mediaPlayer.media.childNodes[0].paused;
    }

    /**
     * Check current visualizer
     * @returns {boolean}
     *-------------------------------------------------------------------------------*/
    var isCurrentVisualizer = function (id) {
        if (playlist) {
            var currentRadio = playlist.find(item => item.id === id);
            return isMediaPlaying() && (currentRadio && currentRadio.isPlaying);
        }
        return false;
    }

    /**
     * Get radio from data attributes
     * @param {HTML} el
     * @returns {object}
     *-------------------------------------------------------------------------------*/
    var getRadio = function (el) {
        el = el.get(0);
        return {
            id: parseInt(el.getAttribute('data-radio-id')),
            cover: el.getAttribute('data-radio-cover'),
            url: el.getAttribute('data-radio-url'),
            title: el.getAttribute('data-radio-title'),
            category: el.getAttribute('data-radio-category')
        };
    }

    /**
     * Get local storage item by name
     * @param {string} name 
     * @returns {object}
     *-------------------------------------------------------------------------------*/
    var getLocalItem = function (name) {
        return JSON.parse(localStorage.getItem(name));
    }

    /**
     * Set local storage item
     * @param {string} name 
     * @param {object} obj 
     *-------------------------------------------------------------------------------*/
    var setLocalItem = function (name, obj) {
        localStorage.setItem(name, JSON.stringify(obj));
    }

    /**
     * Remove local storage item
     * @param {string} name
     *-------------------------------------------------------------------------------*/
    var removeLocalItem = function (name) {
        localStorage.removeItem(name);
    }

    return {
        init() {
            initTooltip();
            reInit();
            routing();
            search();
            stickyContent();
            embeddedAudioPlayer();
            initPlayer();
            setVisualizerPlacement();
            playerEvents();
            addRadio();
            scrollTop();
            loadMore();
            browserAction();
        },
        
        windowResize() {
            var timeout = setTimeout(() => {
                stickyContent();
                setVisualizerPlacement();
                clearTimeout(timeout);
            }, 200);
        }
    }
}();

jQuery(window).on('load', function () {
    Bundle.init();
    $('#loader').fadeOut(500);
});

jQuery(window).on('resize', function () {
    Bundle.windowResize();
});